package cn.com.duiba.kjy.api.remoteservice.novice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.novice.SellerNoviceTaskDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-09-04 15:11
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerNoviceTaskService {

    /**
     * 查询任务列表
     * @param sellerId
     * @return
     */
    List<SellerNoviceTaskDto> listBySellerId(Long sellerId);

    /**
     * 统计已领取金额
     * @param sellerId
     * @return
     */
    Integer countRewardedMoney(Long sellerId);

    /**
     * 完成任务领取奖励
     * @param sellerTaskId
     */
    boolean rewardMoney(Long sellerTaskId);

    /**
     * 根据主键查询
     * @param sellerTaskId
     * @return
     */
    SellerNoviceTaskDto getById(Long sellerTaskId);

    /**
     * 根据代理人id和任务id查询
     * @param sellerId
     * @param taskId
     * @return
     */
    SellerNoviceTaskDto getBySidAndTaskId(Long sellerId, Long taskId);

    /**
     * 代理人任务处理
     * @param sellerId
     * @param taskId
     * @return
     */
    Integer dealTask(Long sellerId, Long taskId);

    /**
     * 新增代理人任务
     * @param sellerNoviceTaskDto
     * @return
     */
    Integer add(SellerNoviceTaskDto sellerNoviceTaskDto);

}
