/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.dto.singlefestival.FestivalAwardConfigDto;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotteryUtil {
    private static final Logger log = LoggerFactory.getLogger(LotteryUtil.class);
    private static final int START = 1;
    private static final int COUNT_UNLIMIT = -1;

    public static FestivalAwardConfigDto getLottery(List<FestivalAwardConfigDto> awardConfigDtoList, Integer lotteryRange) {
        int randomNum = LotteryUtil.getRandomForIntegerBounded(1, lotteryRange);
        int index = 1;
        for (FestivalAwardConfigDto awardConfig : awardConfigDtoList) {
            if (!Objects.equals(awardConfig.getAwardCount(), -1) && awardConfig.getSendedCount() >= awardConfig.getAwardCount()) {
                log.info("\u968f\u673a\u6570:{},\u5956\u54c1\u6ca1\u4e86:{}", (Object)randomNum, (Object)awardConfig.getAwardName());
                return null;
            }
            BigDecimal bd = awardConfig.getProbability();
            if (randomNum >= (index += (bd = bd.multiply(BigDecimal.valueOf(lotteryRange.intValue()))).intValue())) continue;
            awardConfig.setRandom(randomNum);
            return awardConfig;
        }
        log.info("\u968f\u673a\u6570:{}", (Object)randomNum);
        return null;
    }

    public static int getRandomForIntegerBounded(int min, int max) {
        return new RandomDataGenerator().nextInt(min, max);
    }
}

