package cn.com.duiba.kjy.api.enums.singlefestival;

import java.util.Objects;

/**
 * 双十一红包类型
 * @author 吴文哲
 * @date 2019-10-26 17:18
 **/
public enum AwardTypeEnum {
    SELLER_SPECIAL_RED_PACK(1,"付费代理人特殊红包"),
    SELLER_NORMAL_RED_PACK(2,"付费代理人普通红包"),
    FREE_SELLER_NORMAL_RED_PACK(3,"非付费代理人普通红包"),
    VISITOR_NORMAL_RED_PACK(4,"访客普通红包"),
    VISITOR_DEMOTION_RED_PACK(5,"访客降级红包"),
    VISITOR_NO_MONEY_RED_PACK(6,"访客谢谢惠顾红包"),
    ;

    private Integer type;
    private String desc;

    AwardTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static AwardTypeEnum getByType(Integer code) {
        for (AwardTypeEnum enumVal : AwardTypeEnum.values()) {
            if (Objects.equals(enumVal.getType(), code)) {
                return enumVal;
            }
        }
        return null;
    }
}
