package cn.com.duiba.kjy.api.remoteservice.singlefestival;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.singlefestival.FestivalSellerAwardRecordDto;

import java.util.List;

/**
 * @author 吴文哲
 * @date 2019-10-26 16:13
 **/
@AdvancedFeignClient
public interface RemoteFestivalSellerAwardRecordService {

    /**
     * 代理人红包抽奖
     * @param sellerId
     * @param bizNo
     */
    Integer sellerLottery(Long sellerId,String bizNo);

    /**
     * 根据奖券号 查询中奖信息
     * @param bizNo
     * @return
     */
    FestivalSellerAwardRecordDto findSellerForwardRedPack(String bizNo);

    /**
     * 根据sellerId 查找代理人中奖记录
     * @param sellerId
     * @return
     */
    List<FestivalSellerAwardRecordDto> findSellerAwardRecords(Long sellerId);
}
