/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.enums.push.PushEventEnum;
import cn.com.duiba.kjy.api.enums.push.PushMessageTypeEnum;
import cn.com.duiba.kjy.api.util.IdMakerUtil;
import cn.com.duiba.wolf.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class PushEmbedUtils {
    private static final String SEPARATOR = "_";

    public static String getPushParamStr(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return (oaId == null ? "" : IdMakerUtil.encodingId(oaId)) + SEPARATOR + (eventEnum == null ? "" : eventEnum.getEventType()) + SEPARATOR + (messageTypeEnum == null ? "" : messageTypeEnum.getType()) + SEPARATOR + (urlOrder == null ? "" : urlOrder) + SEPARATOR + (dpm == null ? "" : dpm);
    }

    public static String getPushParamStrShort(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return (oaId == null ? "" : Long.valueOf(oaId + 3L)) + SEPARATOR + (eventEnum == null ? "" : eventEnum.getEventType()) + SEPARATOR + (messageTypeEnum == null ? "" : messageTypeEnum.getType()) + SEPARATOR + (urlOrder == null ? "" : urlOrder) + SEPARATOR + (dpm == null ? "" : dpm);
    }

    public static Map<String, String> getPushParamMapByStr(String pushParamStr) {
        if (StringUtils.isBlank((String)pushParamStr)) {
            return Collections.emptyMap();
        }
        Long oaId = null;
        String pushId = null;
        Integer messageType = null;
        Integer urlOrder = null;
        String dpm = null;
        String[] split = pushParamStr.split(SEPARATOR);
        for (int i = 0; i < split.length; ++i) {
            String str = split[i];
            if (StringUtils.isBlank((String)str)) continue;
            if (i == 0) {
                oaId = NumberUtils.isNumber((String)str) ? Long.valueOf(Long.parseLong(str) - 3L) : IdMakerUtil.decodingId(str);
            }
            if (i == 1) {
                pushId = str;
            }
            if (i == 2 && NumberUtils.isNumber((String)str)) {
                messageType = Integer.parseInt(str);
            }
            if (i == 3 && NumberUtils.isNumber((String)str)) {
                urlOrder = Integer.parseInt(str);
            }
            if (i != 4) continue;
            dpm = str;
        }
        return PushEmbedUtils.getPushParamMap(oaId, pushId, messageType, urlOrder, dpm);
    }

    public static String getPushParam(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(oaId, eventEnum, messageTypeEnum, urlOrder, dpm);
        return UrlUtils.buildURLParams(pushParamMap);
    }

    public static String getPushParam(Map<String, String[]> parameterMap) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(parameterMap);
        return UrlUtils.buildURLParams(pushParamMap);
    }

    public static String getEncodePushParam(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        return PushEmbedUtils.encode(PushEmbedUtils.getPushParam(oaId, eventEnum, messageTypeEnum, urlOrder, dpm));
    }

    public static String buildPushParam(String url, Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        Map<String, String> params = PushEmbedUtils.getPushParamMap(oaId, eventEnum, messageTypeEnum, urlOrder, dpm);
        int index = url.indexOf("?");
        if (index < 0) {
            return UrlUtils.appendParams((String)url, params);
        }
        Map map = UrlUtils.uRLRequest((String)url);
        if (MapUtils.isEmpty((Map)map)) {
            return UrlUtils.appendParams((String)url, params);
        }
        String uriUrl = (String)map.get("uri");
        if (StringUtils.isBlank((String)uriUrl)) {
            return UrlUtils.appendParams((String)url, params);
        }
        String decode = PushEmbedUtils.decode(uriUrl);
        String decodePushUrl = UrlUtils.appendParams((String)decode, params);
        map.put("uri", PushEmbedUtils.encode(decodePushUrl));
        return UrlUtils.appendParams((String)UrlUtils.urlPage((String)url), (Map)map);
    }

    public static String buildPushParam(String url, Map<String, String[]> parameterMap) {
        Map<String, String> pushParamMap = PushEmbedUtils.getPushParamMap(parameterMap);
        return UrlUtils.appendParams((String)url, pushParamMap);
    }

    private static Map<String, String> getPushParamMap(Long oaId, PushEventEnum eventEnum, PushMessageTypeEnum messageTypeEnum, Integer urlOrder, String dpm) {
        String pushId = Objects.isNull((Object)eventEnum) ? null : eventEnum.getEventType();
        Integer messageType = Objects.isNull((Object)messageTypeEnum) ? null : messageTypeEnum.getType();
        return PushEmbedUtils.getPushParamMap(oaId, pushId, messageType, urlOrder, dpm);
    }

    private static Map<String, String> getPushParamMap(Long oaId, String pushId, Integer messageType, Integer urlOrder, String dpm) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("push", "push");
        if (Objects.nonNull(oaId)) {
            params.put("oa_id", IdMakerUtil.encodingId(oaId));
        }
        if (Objects.nonNull(pushId)) {
            params.put("push_id", pushId);
        }
        if (Objects.nonNull(messageType)) {
            params.put("message_type", String.valueOf(messageType));
        }
        if (Objects.nonNull(urlOrder)) {
            params.put("url_order", String.valueOf(urlOrder));
        }
        params.put("access_source", PushEmbedUtils.getAccessSourceByPushId(pushId));
        if (StringUtils.isNotBlank((String)dpm)) {
            params.put("dpm", dpm);
        }
        return params;
    }

    private static String getAccessSourceByPushId(String pushId) {
        if (StringUtils.isBlank((String)pushId) || pushId.length() < 2) {
            return "1";
        }
        String accessSource = "10";
        String word = pushId.substring(0, 1);
        String num = pushId.substring(1);
        while (num.length() < 3) {
            num = "0" + num;
        }
        switch (word) {
            case "S": {
                accessSource = accessSource + "1";
                break;
            }
            case "D": {
                accessSource = accessSource + "2";
                break;
            }
            case "H": {
                accessSource = accessSource + "3";
                break;
            }
            case "V": {
                accessSource = accessSource + "4";
                break;
            }
            default: {
                accessSource = accessSource + "5";
            }
        }
        return accessSource + num;
    }

    public static Map<String, String> getPushParamMap(Map<String, String[]> parameterMap) {
        if (MapUtils.isEmpty(parameterMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> params = new HashMap<String, String>(16);
        Set<String> pushKey = PushEmbedUtils.getPushParamMap((Long)0L, "", 0, (Integer)0, null).keySet();
        for (String key : pushKey) {
            String[] param = parameterMap.get(key);
            if (!PushEmbedUtils.isNotEmpty(param)) continue;
            params.put(key, param[0]);
        }
        return params;
    }

    public static String getDpmByPushEventEnum(PushEventEnum eventEnum) {
        if (eventEnum == null) {
            return "";
        }
        if (eventEnum == PushEventEnum.STATISTICS_DAY) {
            return "11.9.0.0";
        }
        if (eventEnum == PushEventEnum.STATISTICS_WEEK) {
            return "11.10.0.0";
        }
        if (eventEnum == PushEventEnum.SUBSCRIBE_WELCOME) {
            return "11.12.0.0";
        }
        if (eventEnum == PushEventEnum.ACTIVATION) {
            return "11.14.0.0";
        }
        if (eventEnum == PushEventEnum.VISIT_FIRST) {
            return "11.15.0.0";
        }
        if (eventEnum == PushEventEnum.VISIT_NON_FIRST) {
            return "11.16.0.0";
        }
        if (eventEnum == PushEventEnum.ACTIVITY_FORM_SUBMIT) {
            return "11.17.0.0";
        }
        if (eventEnum == PushEventEnum.PREFERENTIAL_INFORMATION) {
            return "11.18.0.0";
        }
        if (eventEnum == PushEventEnum.PRIVATE_CHAT_ACCESS) {
            return "11.19.0.0";
        }
        if (eventEnum == PushEventEnum.PRIVATE_CHAT_SEND) {
            return "11.20.0.0";
        }
        if (eventEnum == PushEventEnum.DISTRIBUTION) {
            return "11.22.0.0";
        }
        if (eventEnum == PushEventEnum.REWARDED) {
            return "11.23.0.0";
        }
        if (eventEnum == PushEventEnum.STATISTICS_VIP_INCOME) {
            return "11.24.0.0";
        }
        if (eventEnum == PushEventEnum.INTERACTIVE_PUSH) {
            return "11.25.0.0";
        }
        if (eventEnum == PushEventEnum.SELLER_CARD_REAL_TIME_PUSH) {
            return "11.26.0.0";
        }
        if (eventEnum == PushEventEnum.FORWARD_CONTENT_PUSH) {
            return "11.27.0.0";
        }
        if (eventEnum == PushEventEnum.FORWARD_SELLER_CARD_PUSH) {
            return "11.28.0.0";
        }
        if (eventEnum == PushEventEnum.ACTIVITY_FORM_SUBMIT_NON_REAL_TIME) {
            return "11.30.0.0";
        }
        if (eventEnum == PushEventEnum.ACTIVITY_FORM_SUBMIT_LOTTERY) {
            return "11.31.0.0";
        }
        if (eventEnum == PushEventEnum.WEEKLY_THUMBS_UP) {
            return "11.32.0.0";
        }
        if (eventEnum == PushEventEnum.SCAN_PROM) {
            return "11.34.0.0";
        }
        if (eventEnum == PushEventEnum.NATIONAL_DAY_ACTIVITY) {
            return "11.37.0.0";
        }
        if (eventEnum == PushEventEnum.CLICK_CONTACT_PHONE) {
            return "11.0.1.28";
        }
        if (eventEnum == PushEventEnum.CLICK_CONTACT_WX) {
            return "11.0.1.29";
        }
        if (eventEnum == PushEventEnum.READING) {
            return "11.0.1.30";
        }
        if (eventEnum == PushEventEnum.CLICK_CONTACT) {
            return "11.0.1.32";
        }
        if (eventEnum == PushEventEnum.LIKE_CARD_INTERACTION_FROM_OTHER) {
            return "11.0.1.33";
        }
        if (eventEnum == PushEventEnum.INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH1) {
            return "11.0.1.37";
        }
        if (eventEnum == PushEventEnum.INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH2) {
            return "11.0.1.38";
        }
        if (eventEnum == PushEventEnum.INVESTMENT_INVESTMENT_TIMING_CONTENT_PUSH3) {
            return "11.0.1.43";
        }
        if (eventEnum == PushEventEnum.INCREASE_USER_CLUE_ACTIVITY) {
            return "11.0.1.39";
        }
        if (eventEnum == PushEventEnum.INVESTMENT_CLUE_ACTIVITY) {
            return "11.0.1.40";
        }
        if (eventEnum == PushEventEnum.INCREASE_USER_CLUE_ARTICLE) {
            return "11.0.1.41";
        }
        if (eventEnum == PushEventEnum.INVESTMENT_CLUE_ARTICLE) {
            return "11.0.1.42";
        }
        return "";
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public static String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private static boolean isNotEmpty(String[] param) {
        return Objects.nonNull(param) && param.length > 0;
    }
}

