package cn.com.duiba.kjy.api.dto.activity;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/10/23 5:56 PM
 */
@Data
public class ActivityCustomPrizeDto implements Serializable {

    private static final long serialVersionUID = -1876706552648559919L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 活动配置ID，对应tb_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeImg;

    /**
     * 总库存
     */
    private Integer totalStock;

    /**
     * 剩余库存
     */
    private Integer remainingStock;

    /**
     * 中奖人，以英文逗号分隔，对应tb_activity_winner.id
     */
    private String prizeWinner;
}
