package cn.com.duiba.kjy.api.dto.fission;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Data
@ToString
public class FissionPartakeRecordDto implements Serializable {

    private static final long serialVersionUID = -1148817765345865207L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 奖品id
     */
    private Long awardId;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 参与用户id
     */
    private Long userId;

    /**
     * 上级用户id
     */
    private Long sourceUserId;

    /**
     * 目标助力数
     */
    private Integer targetAssistanceNum;

    /**
     * 已助力数
     */
    private Integer assistanceNum;

    /**
     * 状态
     * @see cn.com.duiba.kjy.api.enums.fission.PartakeRecordStateEnum
     */
    private Integer state;

    /**
     * 完成时间
     */
    private Date finishTime;

    /**
     * 接收奖品时间
     */
    private Date reveiveAwardTime;

    /**
     * 分享次数
     */
    private Integer shardNum;

    /**
     * 当前参与用户海报分享链接
     */
    private String imageUrl;

    /**
     * 微信还有状态
     * @see cn.com.duiba.kjy.api.enums.fission.PartakeRecordFriendStateEnum
     */
    private Integer friendState;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 完成时间
     */
    private Date gmtModified;

}