package cn.com.duiba.kjy.api.enums.fission;

import cn.com.duiba.kjy.api.enums.content.RecommendStateEnum;

import java.util.Objects;

/**
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月31日 16:15
 **/
public enum FissionChatTypeEnum {

    SEND_SIMPLE_TEXT(1, "SEND_SIMPLE_TEXT", "文本消息"),

    SEND_SHARE_BANNER_ACTION(2, "SEND_SHARE_BANNER_ACTION", "海报消息"),

    SEND_ADD_SELLER_WE_CHAT_FRIEND_ACTION(3, "SEND_ADD_SELLER_WE_CHAT_FRIEND_ACTION", " 添加微信好友消息"),

    SEND_BOOST_ACTION(4, "SEND_BOOST_ACTION", "用户助力消息") ,

    SEND_RECEIVE_AWARD_ACTION(5, "SEND_RECEIVE_AWARD_ACTION", "参加活动消息"),

    ASSISTANCE_NOTIFY(6, "ASSISTANCE_NOTIFY", "好友助力通知"),

    ACTIVITY_FINISH_NOTIFY(7, "ASSISTANCE_FINISH_NOTIFY", "活动完成通知"),

    ASSISTANCE_NOTIFY_SUFFIX(8, "ASSISTANCE_NOTIFY_SUFFIX", "好友助力通知后置通知"),

    AWARD_SUGGEST(9, "AWARD_SUGGEST", "奖品建议消息"),

    FINISH_WECHAT_MESSAGE(10, "FINISH_WECHAT_MESSAGE", "活动完成微信好友消息通知"),

    TARGET_ASSISTANCE_MESSAGE(11, "TARGET_ASSISTANCE_MESSAGE", "目标助力消息"),

    SEND_OPEN_AWARD_ACTION(12, "SEND_OPEN_AWARD_ACTION", "发送打开奖品详情页的动作消息"),
    ;

    private Integer value;
    private String code;
    private String text;

    FissionChatTypeEnum(Integer value, String code, String text) {
        this.value = value;
        this.code = code;
        this.text = text;
    }

    public static FissionChatTypeEnum getByValue(Integer value){
        if (Objects.isNull(value)){
            return null;
        }
        for (FissionChatTypeEnum enumVal : FissionChatTypeEnum.values()) {
            if (enumVal.getValue().equals(value)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getValue() {
        return value;
    }

    public String getCode() {
        return code;
    }

    public String getText() {
        return text;
    }
}
