package cn.com.duiba.kjy.api.remoteservice.customize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ContentDto;
import cn.com.duiba.kjy.api.dto.customize.CustomizeFieldContentDto;
import cn.com.duiba.kjy.api.dto.customize.CustomizeFieldDto;
import cn.com.duiba.kjy.api.params.customize.CustomizeFieldContentQryParams;
import cn.com.duiba.kjy.api.params.customize.CustomizeFieldQryParams;

import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2019/6/28 14:23
 * @descript
 */
@AdvancedFeignClient
public interface RemoteCustomizeFieldContentService {


    /**
     * 查询列表
     * @param params
     * @return
     */
    List<CustomizeFieldContentDto> listByParams(CustomizeFieldContentQryParams params);

    /**
     * 查询总数
     * @param params
     * @return
     */
    int countByParams(CustomizeFieldContentQryParams params);

    /**
     * 批量插入活动资料
     * @param dtos
     * @return
     */
    int batchInsert(List<CustomizeFieldContentDto> dtos);

    /**
     * 删除活动资料
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据字段查询出所有使用中的活动
     * @param fieldId
     * @return
     */
    List<ContentDto> listActivitiesByFieldId(Long fieldId);

    /**
     * 获取所有的自定义列表
     * @return
     */
    List<CustomizeFieldDto> getAllCustmoizeField();

    /**
     * 根据contentIds 找到对应的字段信息
     * @param contentIds
     * @return
     */
    Map<Long,List<CustomizeFieldContentDto>> listByContentIds(List<Long>contentIds);

    /**
     * 统计绑定的活动数量 key=线索id value=绑定的活动数
     * @param customizeFieldIds
     * @return
     */
    Map<Long, Integer> countBindContentNum(List<Long> customizeFieldIds);
}
