package cn.com.duiba.kjy.api.remoteservice.accurateTag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.accurate.AccurateContentDto;
import cn.com.duiba.kjy.api.dto.tag.ItemTagDto;
import cn.com.duiba.kjy.api.dto.tag.ItemTagExtDto;
import cn.com.duiba.kjy.api.enums.accurate.AccurateContentTypeEnum;
import cn.com.duiba.kjy.api.params.accurate.AccuratePageBackParam;
import cn.com.duiba.kjy.api.params.accurate.AccuratePageParam;

import java.util.List;
import java.util.Map;

/**
 * item和标签关联关系service
 * @author zhanghuifeng
 * date 2019-04-11-15:11
 */
@AdvancedFeignClient
public interface RemoteItemAccurateTagService {

    /**
     * 根据标签集合获取存在的标签集合
     * @param tagIds
     * @return
     */
    List<Long> findExitTagIdsByTagIds(List<Long> tagIds);

    Map<Long/*contentId*/, Map<Integer/*level*/, List<ItemTagExtDto>>> findTagByItemIds(List<Long> itemIdList);
	
	/**
     * 根据itemId集合获取
     * @param itemIds
     * @param itemType @see TagItemTypeEnum
     * @return
     */
    List<ItemTagDto> findByItemIds(List<Long> itemIds, Integer itemType);

    /**
     * 根据标签获取文章列表
     * @param tag
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<Long> pageContent(Long tag,Long companyId,Integer pageNo,Integer pageSize);


    /**
     * 根据标签获取文章总数
     * @param tag
     * @return
     */
    Long pageContentCount(Long tag,Long companyId);

    /**
     * 根据素材ID获取一级标签ID
     * @param contentId
     * @return
     */
    Long  getFristTagId(Long contentId);


    /**
     * 根据标签获取文章列表(根据内容类型)
     * @param accuratePageParam
     * @return
     */
    List<Long> pageContentByContentType(AccuratePageParam  accuratePageParam);


    /**
     * 获取文章列表加文章类型列表
     * @param accuratePageParam
     * @return
     */
    List<AccurateContentDto> pageContentAndTypeByContentType(AccuratePageParam  accuratePageParam);


    /**
     * 根据标签获取文章总数
     * @param accuratePageParam
     * @return
     */
    Long pageContentCountByContentType(AccuratePageParam  accuratePageParam);


    /**
     * 根据标签和内容类型获取文章列表(管理端使用)
     * @param accuratePageBackParam
     * @return
     */
    List<AccurateContentDto> pageContentForBack(AccuratePageBackParam accuratePageBackParam);


    /**
     * 根据标签获取文章总数(管理端使用)
     * @param accuratePageBackParam
     * @return
     */
    Long pageContentCountForBack(AccuratePageBackParam  accuratePageBackParam);

    /**
     * 通过contentId删除精准素材
     * @param cid
     * @return
     */
    boolean  delByContent(Long cid);

    /**
     * 更新排序
     * @param sourceId  移动的contentId
     * @param targetId  目标位置的contentId
     * @return
     */
    boolean  updateSort(Long sourceId,Long targetId);

    /**
     * 根据内容ID获取的内容类型
     * @param cid
     * @return
     */
    AccurateContentTypeEnum  getAccurateTypeByCid(Long cid);
}
