package cn.com.duiba.kjy.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionPartakeRecordDto;
import cn.com.duiba.kjy.api.params.fission.FissionPartakeRecordQueryParam;

import java.util.List;

/**
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月31日 16:25
 **/

@AdvancedFeignClient
public interface RemoteFissionPartakeRecordService {

    /**
     * 保存活动参与记录
     * @param dto
     * @return
     */
    FissionPartakeRecordDto save(FissionPartakeRecordDto dto);

    /**
     * 根据id查找
     * @param id
     * @return
     */
    FissionPartakeRecordDto findById(Long id);

    /**
     * 查找当前用户的参与记录
     * @param userId 用户id
     * @return
     */
    List<FissionPartakeRecordDto> findByUserId(Long userId);

    /**
     * 根据参数查询
     * @param queryParam
     * @return
     */
    List<FissionPartakeRecordDto> findByQuery(FissionPartakeRecordQueryParam queryParam);

    /**
     * 根据活动idh和用户id查找
     * @param activityId 活动id
     * @param userId 用户id
     * @return
     */
    FissionPartakeRecordDto findByActivityIdAndUserId(Long activityId, Long userId);

    /**
     * 根据id修改，id必传
     * @param dto
     * @return
     */
    Boolean updateById(FissionPartakeRecordDto dto);

    /**
     * 添加活动助力
     * @param partakeRecordId
     * @param userId
     * @return
     */
    Boolean assistance(Long partakeRecordId, Long userId);

    /**
     * 添加分享次数
     * @param id
     * @return
     */
    Boolean addShardNum(Long id);

    /**
     * 根据活动id统计转发次数
     * @param activityId
     * @return
     */
    Integer sumShardNumByActivityId(Long activityId);

    /**
     * 根据条件统计数量
     * @param queryParam
     * @return
     */
    Integer countByParam(FissionPartakeRecordQueryParam queryParam);
}
