package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SiteSaleQrCodeInfoDto;

/**
 * 会销码相关信息
 * @author zhanghuifeng
 * date 2019/11/26-1:47 下午
 */
@AdvancedFeignClient
public interface RemoteSiteSaleQrCodeInfoService {

    /**
     * 保存
     * @param dto
     * @return
     */
    Boolean save(SiteSaleQrCodeInfoDto dto);

    /**
     * 根据销售员ID获取有效的会销码信息
     * @param sellerId 销售ID
     * @return
     */
    SiteSaleQrCodeInfoDto findValidInfoBySellerId(Long sellerId);
}
