package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.GrabContentDto;
import cn.com.duiba.kjy.api.params.GrabContentParam;

import java.util.List;

/**
 * Created by dugq on 2019-04-24.
 */
@AdvancedFeignClient
public interface RemoteGrabContentService {
    GrabContentDto selectOne(Long id);

    /**
     * 根据url查询最近的一条记录的ID
     * @param sourceUrl
     * @return
     */
    Long countBySourceUrl(String sourceUrl);

    List<GrabContentDto> selectList(GrabContentParam pojo);

    int update(GrabContentDto record);

    Integer selectCount(GrabContentParam pojo);

    Long insert(GrabContentDto pojo);

    Integer delete(Long id);

    /**
     * 把爬虫库的文章移动到文章库
     * @param id
     * @return
     * @throws KjyCenterException
     */
    Long moving2ArticleList(Long id) throws KjyCenterException;

    /**
     * 下一篇文章
     * @param id
     * @param firstSign
     * @param secondSign
     * @param contentLocation
     * @return
     */
    GrabContentDto nextContent(Long id, String firstSign, String secondSign, Integer contentLocation);
}
