package cn.com.duiba.kjy.api.util;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 活动指定中奖，昵称模糊匹配工具方法
 * Created by zzy on  2019/11/23 17:35
 */
public class NicknameMatchUtil {
    /**
     * 昵称是否匹配
     *
     * @param target   目标昵称（昵称全名）
     * @param nickname 昵称（用户输入，昵称部分字符）,至少2个字符以上
     * @return true-匹配，false-不匹配
     */
    public static boolean isMatch(String target, String nickname) {
        if (Objects.equals(target, nickname)) {
            return true;
        }
        if (StringUtils.isAnyEmpty(target, nickname) || nickname.length() < 2) {
            return false;
        }
        return target.toLowerCase().contains(nickname.toLowerCase());
    }
}
