package cn.com.duiba.kjy.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionChatRecordDto;

import java.util.List;

/**
 * 远程裂变聊天记录服务
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月31日 19:08
 **/
@AdvancedFeignClient
public interface RemoteFissionChatRecordService {

    /**
     * 保存
     * @param dto
     * @return
     */
    FissionChatRecordDto save(FissionChatRecordDto dto);

    /**
     * 根据活动id与接收者用户id查询
     * @param activityId 活动id
     * @param senderUserId 发送者用户id
     * @param receiveUserId 接受者用户id
     * @return
     */
    List<FissionChatRecordDto> findByActivityAndUserIds(Long activityId, Long senderUserId, Long receiveUserId);

    /**
     * 获取全部的消息
     * @param activityId
     * @param partakeRecordId
     * @param receiverUserId
     * @param senderUserId 发送者用户id
     * @return
     */
    List<FissionChatRecordDto> getAllChatRecords(Long activityId, Long partakeRecordId, Long receiverUserId, Long senderUserId);

    /**
     * 更新未读消息为已读消息
     * @param activityId 活动id
     * @param receiveUserId 接收人id
     * @param senderUserId 用户id
     * @param lastId 最后一条消息id
     * @return
     */
    Boolean readed(Long activityId, Long receiveUserId, Long senderUserId, Long lastId);

    /**
     * 根据会话流程flowId修改接收者用户id
     * @param receiveUserId
     * @param flowId
     * @return
     */
    Boolean updateReceiveUserIdByFlowId(Long receiveUserId, String flowId);

    /**
     * 根据用户id查询
     * @param id
     * @return
     */
    FissionChatRecordDto findById(Long id);
}
