package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SellerDto;
import cn.com.duiba.kjy.api.dto.SellerUserDto;
import cn.com.duiba.kjy.api.dto.company.CompanyBindingSellerCountDto;
import cn.com.duiba.kjy.api.enums.seller.SellerShowQrCodeTypeEnum;
import cn.com.duiba.kjy.api.enums.seller.SellerSpSwitchEnum;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchVipSellerParam;
import cn.com.duiba.kjy.api.params.SellerCardParam;
import cn.com.duiba.kjy.api.params.SellerSearchParam;

import java.util.List;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteSellerService {

    /**
     * 通过id查询销售信息
     * @param param
     * @return
     */
    List<SellerDto> findByParam(SellerSearchParam param);

    /**
     * 通过id查询销售信息
     * @param param
     * @return
     */
    Integer countByParam(SellerSearchParam param);

    /**
     * 通过id查询销售信息
     * @param sellerId
     * @return
     */
    SellerDto findById(Long sellerId);

    /**
     * 根据用户ID查询
     * @param userId 用户ID
     * @return
     */
    SellerDto findByUserId(Long userId);

    /**
     * 查询销售员列表
     * @param param
     * @return
     */
    Page<SellerDto> searchVipSellerList(SearchVipSellerParam param);

    SellerUserDto findSellerUserById(Long sellerId);

    /**
     *
     * @param dto
     * @return  0L 失败 其他为id
     */
    Long insert(SellerDto dto);

    Boolean update(SellerDto dto);

    /**
     * 更新销售二维码
     * @param qrCode
     * @param id
     * @return
     */
    int updateQrCodeById(String qrCode, Long id);

    /**
     * 更新用户通知设置
     * @param sellerId
     * @param state
     * @return
     */
    int updateNotificationSetting(Long sellerId,Integer state);


    /**
     * 更新销售名片
     * @param param
     * @return
     */
    /**
     * 名片2.0 需求重构
     * @param param
     * @return
     */
    @Deprecated
    int editMyCard(SellerCardParam param);

    /**
     * 批量查询销售员信息
     * @param ids
     * @return
     */
    List<SellerDto> findByIds(List<Long> ids);

    /**
     * 当前公司关联的激活码绑定的用户数
     * @param companyIds
     * @return
     */
    List<CompanyBindingSellerCountDto> findCompanyBindingCount(List<Long> companyIds);

    /**
     * 根据公司ID获取销售员数
     * @param companyId
     * @return
     */
    int findCountByCompany(Long companyId);

    /**
     * 更新销售员公司信息
     * @param id
     * @param companyId
     * @return
     */
    Boolean updateCompany(Long id,  Long companyId);

    /**
     * 根据销售员ID获取公司ID
     * @param id
     * @return
     */
    Long findCompanyById(Long id);

    /**
     * 批量修复销售员公司数据
     * @return
     */
    Boolean batchFixSellerCompany();

    /**
     * 更新销售员特殊类型(如会销特权)
     * @param id
     * @param sellerSpType （可设置为空）
     * @return
     */
    Boolean updateSellerSpType(Long id, Integer sellerSpType);

    /**
     * 更新销售员特权开关
     * @param id
     * @param spSwitchEnum
     * @see SellerSpSwitchEnum
     * @return
     */
    Boolean updateSellerSpTypeSwitch(Long id, SellerSpSwitchEnum spSwitchEnum);

    /**
     * 是否是付费开通会员
     * @param sellerId 销售员ID
     * @return true-是，false-不是
     */
    boolean isPayVip(Long sellerId);

    /**
     * 是否是付费开通会员
     * @param sellerDto 销售员
     * @return true-是，false-不是
     */
    @Deprecated
    boolean isPayVipSeller(SellerDto sellerDto);


    /**
     * 更新销售员展示二维码类型
     * @param typeEnum 展示二维码类型
     * @param id 销售员ID
     * @return 更新条数
     */
    int updateShowQrCodeTypeById(SellerShowQrCodeTypeEnum typeEnum, Long id);

    /**
     * 升级vip状态为特权会员(并发送相关模版消息)
     * @param sellerId
     * @return
     */
    Boolean upgradeSpVip(Long sellerId);

    /**
     * 根据用户id列表查询代理人
     * @param userIds
     * @return
     */
    List<SellerDto> listByUserIds(List<Long> userIds);

    /**
     * 重置会员开始结束时间
     * @param sellerId
     * @return
     */
    Integer resetSellerVipDate(Long sellerId);

    /**
     * 获取某个公司下到所有sellerId
     * @param companyId
     * @return
     */
    List<Long> findIdsByCompanyId(Long companyId);

    /**
     * 根据userId 找到对应的SellerId集合
     * @param userIds
     * @return
     */
    List<Long> findSellerIdsByUserIds(List<Long> userIds);

    /**
     * 更新Seller的微信二维码
     * @param sellerId
     * @param wechatQrCode
     * @return
     */
    Boolean updateWechatQrCode(Long sellerId,String wechatQrCode);

    /**
     * 更新Seller的微信头像
     * @param sellerId
     * @param avatar
     * @return
     */
    Integer updateAvatar(Long sellerId,String avatar);

    /**
     * 获取有效会员的id
     * @return
     */
    List<Long> listValidVipIds(Integer offset, Integer pageSize);

    /**
     * 根据用户ID查询销售ID
     * @param userId
     * @return
     */
    Long findIdByUserId(Long userId);

}
