package cn.com.duiba.kjy.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionActivityDto;
import cn.com.duiba.kjy.api.params.fission.FissionActivityQueryParam;

import java.util.List;

/**
 * 远程代理人活动服务
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月29日 18:01
 **/

@AdvancedFeignClient
public interface RemoteFissionActivityService {

    /**
     * 保存代理人活动
     * @param awardId 奖品id
     * @param sellerId 销售员id
     * @return
     */
    FissionActivityDto save(Long awardId, Long sellerId);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    FissionActivityDto findById(Long id);

    /**
     *  根据销售员id查询
     * @param sellerId 销售员id
     * @return
     */
    List<FissionActivityDto> findBySellerId(Long sellerId);

    /**
     * 根据id修改，id必传
     * @param dto
     * @return
     */
    Boolean updateById(FissionActivityDto dto);

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<FissionActivityDto> findByQuery(FissionActivityQueryParam param);

    /**
     * 添加转发次数
     * @param id
     * @return
     */
    Boolean addForwardNum(Long id);

    /**
     * 添加参与次数
     * @param id
     * @return
     */
    Boolean addPartakeNum(Long id);

    /**
     * 添加完成人数
     * @param id
     * @return
     */
    Boolean addFinishNum(Long id);
}
