package cn.com.duiba.kjy.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionAssistanceRecordDto;
import cn.com.duiba.kjy.api.params.fission.FissionAssistanceRecordQueryParam;

import java.util.List;

/**
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年11月05日 13:22
 **/
@AdvancedFeignClient
public interface RemoteFissionAssistanceRecordService {

    /**
     * 根据参与记录id查询助力记录
     * @param partakeId
     * @return
     */
    List<FissionAssistanceRecordDto> findByPartakeId(Long partakeId);

    /**
     * 根据条件查询
     * @param queryParam
     * @return
     */
    List<FissionAssistanceRecordDto> findByQuery(FissionAssistanceRecordQueryParam queryParam);

    /**
     * 获取总的助力数
     * @return
     */
    Integer count();
}
