package cn.com.duiba.kjy.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.lottery.LotteryWinningRecordDto;
import cn.com.duiba.kjy.api.dto.lottery.detail.LotteryWinningRecordDetailDto;
import cn.com.duiba.kjy.api.enums.lottery.PrizeStateEnum;
import cn.com.duiba.kjy.api.params.lottery.LotteryWinningRecordParams;

import java.util.List;

/**
 * @author lizhi
 * @date 2019/10/23 3:52 PM
 */
@AdvancedFeignClient
public interface RemoteLotteryWinningRecordService {

    /**
     * 分页查询中奖记录
     * @param params 参数
     * @return 中奖记录
     */
    List<LotteryWinningRecordDto> findPage(LotteryWinningRecordParams params);

    /**
     * 查询中奖记录总条数
     * @param params 参数
     * @return 总条数
     */
    long selectCount(LotteryWinningRecordParams params);

    /**
     * 领取奖品
     * @param id 主键
     * @return true-成功，false-失败
     */
    boolean received(Long id);

    /**
     * 根据订单ID查询
     * @param orderId 订单ID
     * @return 中奖记录
     */
    LotteryWinningRecordDetailDto findByOrderId(Long orderId);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 中奖记录
     */
    LotteryWinningRecordDto findById(Long id);
}
