package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.enums.seller.SellerImportTaskStatusEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2019-06-05
 */
@Data
@ToString
public class SellerImportTaskDto implements Serializable {

    private static final long serialVersionUID = -5346674794321434365L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 原文地址
     */
    private String sourceUrl;

    /**
     * 内容ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 状态，1=未执行、2=执行中、3=调用失败、4=执行失败、5=执行成功、6=完成
     *
     * @see SellerImportTaskStatusEnum
     */
    private Integer state;

    /**
     * 执行失败的详细错误信息
     */
    private String errMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 原文地址md5值
     */
    private String sourceUrlCode;

    /**
     * 导入来源
     */
    private Integer importSource;

    /**
     * 导入类型
     * @see cn.com.duiba.kjy.api.enums.SellerImportTypeEnum
     */
    private Integer importType;

}
