package cn.com.duiba.kjy.api.params.lottery;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/10/23 3:05 PM
 */
@Data
public class LotteryTimesParams implements Serializable {

    private static final long serialVersionUID = -8294411454222169167L;

    /**
     * 初始次数
     */
    private Integer initialTimes;

    /**
     * 每次分享增加次数
     */
    private Integer everyShareAddTimes;

    /**
     * 最大次数
     */
    private Integer maxTimes;

    /**
     * 次数类型：0-永久，1-每日
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryTimesTypeEnum
     */
    private Integer timesType;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 销售员ID
     */
    private Long sellerId;

    /**
     * 访问者用户ID
     */
    private Long visitorId;

    /**
     * 记录或分享次数
     */
    private Integer increaseNum;
}

