package cn.com.duiba.kjy.api.remoteservice.accurate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.accurate.SellerAccurateMaterialDto;

/**
 * 代理人线索信息
 * @author 吴文哲
 * @date 2019-11-07 16:21
 **/
@AdvancedFeignClient
public interface RemoteSellerAccurateMaterialService {

    /**
     * 保存代理人线索详情
     * @param sellerAccurateMaterial
     * @return
     */
    Long save(SellerAccurateMaterialDto sellerAccurateMaterial);

    /**
     * 更新精准素材 有没有用标识
     * @param cluId
     * @param useful
     * @return
     */
    Integer updateAccurateMaterialUseful(Long cluId,Integer useful);

    /**
     * 根据线索Id查找精准线索
     * @param clueId
     * @return
     */
    SellerAccurateMaterialDto findAccurateMaterialById(Long clueId);

}
