package cn.com.duiba.kjy.api.constant;

import cn.com.duiba.kjy.api.enums.seller.SellerFromEnum;

import java.util.Objects;

/**
 * @auther: linjianhui
 * @date: 2019-10-16 17:32
 * @description: 销售来源与客集集来源映射
 */
public enum SellerAccessSourceEnum {

    PRIVATE_CHAT(SellerFromEnum.PRIVATE_CHAT,15,"私信页面-聊天界面"),
    /**
     * 一般途径：包含关注、扫码关注、扫码事件（已关注）
     */
    NORMAL_SUBSCRIBE(SellerFromEnum.NORMAL,47,"一般途径"),

    INVITE_FRIEND(SellerFromEnum.POSTER_INVITE,22,"分享付费会员开通页面，邀请好友"),

    CHANGE_CARD(SellerFromEnum.CARD,48,"换成我的,内容页换名片邀请"),

    SITE_SALE_QR(SellerFromEnum.SITE_SALE_QR,49,"会销邀请"),

    OUR_INSIDE_RECOMMEND(SellerFromEnum.OUR_INSIDE_RECOMMEND,50,"公司内部销售推荐"),

    WEEKLY_PUBLICATION(SellerFromEnum.WEEKLY_PUBLICATION,51,"周报中关注客集集"),

    NOVICE_TASK(SellerFromEnum.NOVICE_TASK,52,"新手任务邀请"),

    ACTIVATE_CODE(SellerFromEnum.ACTIVATE_CODE,45,"激活码"),

    WX_MP_BASE_AUTH(SellerFromEnum.WX_MP_BASE_AUTH,46,"小程序授权"),

    WX_FISSION_MP_BSE_AUTH(SellerFromEnum.WX_FISSION_MP_BSE_AUTH, 80, "微信裂变小程序授权"),
    ;

    /**
     * 销售来源定义
     */
    private SellerFromEnum sellerFromEnum;

    /**
     * 客集集来源
     */
    private Integer accessSource;

    /**
     * 描述
     */
    private String desc;

    SellerAccessSourceEnum(SellerFromEnum sellerFromEnum,Integer accessSource, String desc) {
        this.sellerFromEnum = sellerFromEnum;
        this.accessSource = accessSource;
        this.desc = desc;
    }

    public static SellerAccessSourceEnum getBySellerFromEnum(SellerFromEnum sellerFromEnum){
        if (Objects.isNull(sellerFromEnum)){
            return null;
        }
        for (SellerAccessSourceEnum sellerAccessSourceEnum:values()){
            if (sellerAccessSourceEnum.getSellerFromEnum().equals(sellerFromEnum)){
                return sellerAccessSourceEnum;
            }
        }
        return null;
    }

    public SellerFromEnum getSellerFromEnum() {
        return sellerFromEnum;
    }

    public Integer getAccessSource() {
        return accessSource;
    }

    public String getDesc() {
        return desc;
    }}
