package cn.com.duiba.kjy.api.mqmsg;

import cn.com.duiba.kjy.api.enums.push.PushEventEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2019/7/6 6:26 PM
 */
@Data
public class KjjBatchPushMsg implements Serializable {

    private static final long serialVersionUID = -3713062033361779319L;

    /**
     * 客服消息
     */
    public static final int TYPE_KEFU = 1;
    /**
     * 模板消息
     */
    public static final int TYPE_TEMPLATE = 2;
    /**
     * 图文客服消息
     */
    public static final int TYPE_KEFU_PIC_TEXT = 3;

    public static final int TYPE_KEFU_PIC = 4;

    /**
     * 客服消息： 小程序卡片
     */
    public static final int TYPE_KEFU_MP_CARD = 4;

    /**
     * 消息类型
     */
    private int type;

    /**
     * 公众号ID
     */
    private Long oaId;

    /**
     * 收信息的用户openId
     */
    private List<User4Message> users;

    /**
     * 消息关键信息，目前使用场景：
     * 1.作为模板消息id
     */
    private String key;

    /**
     * 消息内容
     */
    private String body;

    /**
     * 模板跳转链接
     */
    private String url;

    /**
     * 图文客服消息
     */
    private KjjKefuPicTextMsg kjjKefuPicTextMsg;

    /**
     * 推送事件
     */
    private PushEventEnum pushEventEnum;

    /**
     * 跳转的小程序
     */
    private String mpAppId;

    /**
     * 小程序的页面地址
     */
    private String page;
}
