package cn.com.duiba.kjy.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2019/10/23 5:56 PM
 */
@Data
public class ActivityConfLotteryDto implements Serializable {

    private static final long serialVersionUID = -872734589296511277L;

    /**
     * 销售员转发活动ID
     */
    private Long scId;

    /**
     * 销售员ID
     */
    private Long sellerId;

    /**
     * 销售员用户ID
     */
    private Long sellerUserId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 记录类型：article =文章、seller =名片 activity =活动 daily=日报
     * @see cn.com.duiba.kjy.api.constant.ContentTypeEnum
     */
    private String contentType;

    /**
     * 销售员执行的中奖人及奖品列表
     */
    private List<ActivityCustomPrizeDto> activityCustomPrizeDtos;

    /**
     * 优惠券ID
     */
    private List<Long> couponIds;
}
