package cn.com.duiba.kjy.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.user.UserCollectItemDto;
import cn.com.duiba.kjy.api.params.user.UserCollectionQryParams;

import java.util.List;

/**
 * 用户收藏信息服务
 * @author zhanghuifeng
 * date 2019-04-15-15:10
 */
@AdvancedFeignClient
public interface RemoteUserCollectItemService {

    /**
     * 添加收藏
     * @param dto
     * @return
     */
    Boolean save(UserCollectItemDto dto);

    /**
     * 删除收藏
     * @param userId
     * @param itemId
     * @param itemType @see UserCollectItemTypeEnum
     * @return
     */
    Boolean delete(Long userId, Long itemId, int itemType);

    /**
     * 根据销售员ID分页获取收藏信息
     * @param params
     * @return
     */
    List<UserCollectItemDto> listPageByUserId(UserCollectionQryParams params);

    /**
     * 查询收藏
     * @param userId
     * @param itemId
     * @param itemType @see UserCollectItemTypeEnum
     * @return
     */
    UserCollectItemDto find(Long userId, Long itemId, int itemType);
}
