package cn.com.duiba.kjy.api.remoteservice.wechat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.wechat.WxPushRecordDto;
import cn.com.duiba.kjy.api.enums.push.PushEventEnum;

import java.util.Date;
import java.util.List;

/**
 * 微信推送记录服务
 * @author zhanghuifeng
 * date 2019/12/6-6:01 下午
 */
@AdvancedFeignClient
public interface RemoteWxPushRecordService {

    /**
     * 批量保存（存在即更新最新一次推送时间）
     * @param
     * @return
     */
    Boolean batchSaveExistUpdate(List<Long> sellerIds, PushEventEnum eventEnum, Date lastPushTime, Long oaId);

    /**
     * 保存（存在即更新最新一次推送时间）
     * @param dto
     * @return
     */
    Boolean saveExistUpdate(WxPushRecordDto dto);
}
