package cn.com.duiba.kjy.api.enums;

import java.util.Objects;

/**
 * Created by dugq on 2019-07-02.
 * 1：模版消息，2：客服文字消息，3:客服图文消息 4:发送图片 5：群发消息
 */
public enum MessageConfigTypeEnum {
    TEMPLATE(1,"模版消息"),
    KEFU_TEXT(2,"客服文字消息"),
    KEFU_PIC_TEXT(3,"客服图文消息"),
    KEFU_PIC(4,"客服图片消息"),
    KEFU_ALL(5,"客服群发消息"),
    ;
    private Integer code;
    private String desc;

    MessageConfigTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static MessageConfigTypeEnum Of(Integer type) {
        for (MessageConfigTypeEnum e :values())
            if (Objects.equals(type, e.getCode())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息类型");
    }

}
