package cn.com.duiba.kjy.api.enums.tag;

/**
 * @author zhanghuifeng
 * date 2019-04-15-11:29
 */
public enum TagItemTypeEnum {

    CONTENT(1, "文章和海报"),
    ADMIN_COLLECTION(2,"管理员收藏")
    ;
    private int code;

    private String desc;

    TagItemTypeEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static TagItemTypeEnum getByCode(int code) {
        for (TagItemTypeEnum enumVal : TagItemTypeEnum.values()) {
            if (enumVal.getCode() == code) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(int code) {
        for (TagItemTypeEnum enumVal : TagItemTypeEnum.values()) {
            if (enumVal.getCode() == code) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
