package cn.com.duiba.kjy.api.remoteservice.accurate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.accurate.AccurateAggregationPushBean;
import cn.com.duiba.kjy.api.dto.accurate.SellerAccurateMaterialDto;
import cn.com.duiba.kjy.api.params.accurate.AccurateAggregationPushParam;

import java.util.Date;
import java.util.List;

/**
 * 代理人线索信息
 * @author 吴文哲
 * @date 2019-11-07 16:21
 **/
@AdvancedFeignClient
public interface RemoteSellerAccurateMaterialService {

    /**
     * 保存代理人线索详情
     * @param sellerAccurateMaterial
     * @return
     */
    Long save(SellerAccurateMaterialDto sellerAccurateMaterial);

    /**
     * 更新精准素材 有没有用标识
     * @param cluId
     * @param useful
     * @return
     */
    Integer updateAccurateMaterialUseful(Long cluId,Integer useful);

    /**
     * 根据线索Id查找精准线索
     * @param clueId
     * @return
     */
    SellerAccurateMaterialDto findAccurateMaterialById(Long clueId);

    /**
     * 根据scid  visitorId 查询精准线索
     * @param visitorId
     * @param scid
     * @return
     */
    List<SellerAccurateMaterialDto> findByVisitIdAndScid(Long visitorId,Long scid);


    /**
     * 根据开始时间 结束时间 代理人id 查找精准线索
     * @param param
     * @return
     */
    List<AccurateAggregationPushBean> findByCondition(AccurateAggregationPushParam param);

    /**
     * 统计总数
     * @param param
     * @return
     */
    Integer countByCondition(AccurateAggregationPushParam param);

    /**
     * 精准素材聚合推送
     * @param startDate
     * @param endDate
     * @param sellerId
     */
    void accurateAggregationPush(Date startDate, Date endDate, Long sellerId);

}
