package cn.com.duiba.kjy.api.dto.lottery;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2019/10/23 2:56 PM
 */
@Data
public class LotteryWinningRecordDto implements Serializable {

    private static final long serialVersionUID = -1493793034221909888L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 抽奖ID
     */
    private Long lotteryId;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 活动配置ID，对应tb_seller_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 中奖日期
     */
    private String winningDate;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeImg;

    /**
     * 奖品类型：1-谢谢参与,2-再来一次,3-销售员定制,4-链接优惠券,5-实物
     * @see cn.com.duiba.kjy.api.enums.lottery.PrizeTypeEnum
     */
    private Integer prizeType;

    /**
     * 奖品有效期
     */
    private Date prizeEndTime;

    /**
     * 第三方奖品扩展信息，比如券地址、券码等
     */
    private String thirdPrizeExt;

    /**
     * 奖品状态：0-未领取，1-已领取，2-已过期
     * @see cn.com.duiba.kjy.api.enums.lottery.PrizeStateEnum
     */
    private Integer prizeState;

    /**
     * 自定义奖品配置表ID，对应tb_activity_custom_prize.id
     */
    private Long activityCustomPrizeId;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}

