package cn.com.duiba.kjy.api.enums.push;


import java.util.HashMap;
import java.util.Map;

/**
 * 推送
 * @author lizhi
 * @date 2019/6/24 1:51 PM
 */
public enum PushEnum {
    //推送类型
    DAILY(1, "今日早报更新", ""),
    AFTERNOON(2, "午后话题更新", ""),
    EVENING(3, "晚安心语更新", ""),
    HOT_ARTICLE(4, "爆款热文推荐", ""),
    VISIT(5, "意向客户来访", ""),
    DAILY_STATISTICS(6, "每日客户数据统计", ""),
    WEEKLY_STATISTICS(7, "每周客户数据统计", ""),
    DAILY_EARNINGS(8, "每日收益统计", ""),
    /**
     * 开启免打扰，一定要在PushLabelEnum.DISTURB标签下的第一个，前端对第一个做了特殊处理
     */
    NON_DISTURB(9, "开启免打扰", "开启后在设定时间内不会接收到消息推送"),

    INTERACT_EXPIRE_REMIND(10, "推送已到期提醒", ""),
    ;


    /**
     * 推送类型
     */
    private Integer pushType;
    /**
     * 推送名称
     */
    private String pushName;

    /**
     * 说明
     */
    private String explain;


    PushEnum(Integer pushType, String pushName, String explain) {
        this.pushType = pushType;
        this.pushName = pushName;
        this.explain = explain;
    }

    private static final Map<Integer, PushEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PushEnum pushEnum : values()){
            ENUM_MAP.put(pushEnum.getPushType(), pushEnum);
        }
    }

    public static PushEnum getByPushType(Integer pushType) {
        if (pushType == null) {
            return null;
        }
        return ENUM_MAP.get(pushType);
    }

    public Integer getLabel() {
        switch (this) {
            case DAILY:
                return PushLabelEnum.MATERIAL.getLabel();
            case AFTERNOON:
                return PushLabelEnum.MATERIAL.getLabel();
            case EVENING:
                return PushLabelEnum.MATERIAL.getLabel();
            case HOT_ARTICLE:
                return PushLabelEnum.MATERIAL.getLabel();
            case VISIT:
                return PushLabelEnum.VISIT_ME.getLabel();
            case DAILY_STATISTICS:
                return PushLabelEnum.VISIT_ME.getLabel();
            case WEEKLY_STATISTICS:
                return PushLabelEnum.VISIT_ME.getLabel();
            case DAILY_EARNINGS:
                return PushLabelEnum.VIP_EXCLUSIVE.getLabel();
            case NON_DISTURB:
                return PushLabelEnum.DISTURB.getLabel();
            case INTERACT_EXPIRE_REMIND:
                return PushLabelEnum.WARNING_REMIND.getLabel();
                default:
                return null;
        }
    }

    public Integer getPushType() {
        return pushType;
    }

    public String getPushName() {
        return pushName;
    }

    public String getExplain() {
        return explain;
    }
}
