package cn.com.duiba.kjy.api.mqmsg;

import cn.com.duiba.kjy.api.enums.push.PushEventEnum;
import lombok.Data;
import lombok.ToString;

import javax.annotation.Nullable;
import java.io.Serializable;

/**
 * 客集集会员VIP公众号通知消息结构
 * Created by zzy on  2019/05/29 11:51
 */
@Data
@ToString
public class KjjVipOaWxNotifyMsg implements Serializable {
    private static final long serialVersionUID = 8408110656948198548L;
    /**
     * 客服消息（文字消息）
     */
    public static final int TYPE_KEFU = 1;
    /**
     * 模板消息
     */
    public static final int TYPE_TEMPLATE = 2;

    /**
     * 客服消息（图文消息）
     */
    public static final int TYPE_KEFU_PIC_TEXT = 3;

    /**
     * 客服消息： 小程序卡片
     */
    public static final int TYPE_KEFU_MP_CARD = 4;

    /**
     * 公众号消息
     */
    public static final int DESTINATION_OA = 1;
    /**
     * 小程序消息
     */
    public static final int DESTINATION_MP = 2;

    /**
     * 消息类型
     */
    private int type;
    /**
     * 消息关键信息，目前使用场景：
     * 1.作为模板消息id
     */
    private String key;
    /**
     * 收信息的用户openId
     */
    private String openId;
    /**
     * 消息内容
     */
    private String body;

    /**
     * 模板跳转链接
     */
    @Nullable
    private String url;

    private Long oaId;

    /**
     * 推送类型
     */
    private PushEventEnum pushEventEnum;

    /**
     * 销售员ID
     */
    private Long sellerId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 触发这条消息相关的用户id
     */
    private Long custUserId;

	/**
     * 是否需要降级模版消息
     */
    private Boolean needDemotionTemplate = Boolean.FALSE;

    /**
     * 需要降级的模版消息内容
     */
    private String demotionTemplateBody;

    /**
     * 客服消息标题
     */
    private String title;

    /**
     * 图片url
     */
    private String picUrl;

    /**
     * 发送目的地，1：公众号 2：小程序
     *  兼容旧版本，默认值为1
     */
    private int destination = 1;

    /**
     * 跳转的小程序
     */
    private String mpAppId;

    /**
     * 小程序的页面地址
     */
    private String page;

}
