package cn.com.duiba.kjy.api.enums;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-29.
 * 消息配置的标记。一个功能一个标记。切勿重复哦
 */
public enum MessageMarkEnum {
    /**
     * 公众号、小程序消息配置
     */
    DAILY_TEMPLATE(1,"日报降级"),
    VISIT_TEMPLATE(2,"访问记录降级"),
    BUY_VIP_TEMPLATE(3,"会员购买成功"),
    SHARE_STATISTICS_TEMPLATE(4,"每日统计"),
    EVENING_GREETING_TEMPLATE(5,"晚安问候降级"),
    RETURN_MONEY(6,"收益发放通知"),
    WITHDRAW_MONEY(7,"提现成功通知"),

    VIP_INCOME_STATISTICS_TEMPLATE(8,"每日收益模板消息"),
    GUIDING_SUBSCRIBE_VIP(9,"引导关注VIP客服消息"),
    EVENING_GREETING_KEFU(10,"晚安问候客服消息"),
    USER_IN_CHAT_PAGE(11,"客户咨询客服消息通知，客户首次进入该会话聊天页"),
    USER_IN_CHAT_PAGE_TEMPLATE(12,"客户咨询模板消息通知，客户首次进入该会话聊天页"),
    USER_SEND_MESSAGE(13,"用户咨询客服消息通知，客户给代理人留言"),
    USER_SEND_MESSAGE_TEMPLATE(14,"用户咨询模板消息通知，客户给代理人留言"),
    USER_RECEIVE_MESSAGE(15,"客户接收代理人留言客服消息通知，客户消息小程序"),
    UPGRADE_GRADE_TEMPLATE(16,"等级升级通知"),
    ORDER_SEND_OUT(17,"订单发货通知"),

    AFTERNOON_ACTIVITY_KEFU(18,"下午动画推荐客服消息"),
    AFTERNOON_ACTIVITY_TEMPLATE(19,"下午动画推荐降级"),

    PRIVATE_CHAT_TEMPLATE(20,"代理人回复私聊，小程序模版消息"),

    SALES_PROMOTION_ONE_TEXT(21,"会销未付款用户22小时客服文字消息"),
    SALES_PROMOTION_TWO_TEXT(22,"会销未付款用户48小时客服文字消息"),
    SALES_PROMOTION_REMIND_PIC(23,"会销未付款用户48小时客服图文消息"),
    HOT_CONTENT_TEMPLATE(24, "热点内容模版消息"),
    COLLECT_CONTENT_INTERACTION(25, "收藏通知消息"),
    ACTIVITY_ACCURATE_CLUE(26, "活动精准线索推送"),
    ACCURATE_CLUE_TEMPLATE(27, "精准线索模版推送"),

    FISSION_SOMEONE_HELPED_ASSISTANCE(30, "裂变：有好友帮你助力"),
    FISSION_ASSISTANCE_HELP_OTHER(31, "裂变：帮好友助力"),
    FISSION_ASSISTANCE_SUCCESS(32, "裂变：助力完成，提醒领奖"),
    FISSION_AGENT_TAKE_ACTIVITY(33, "裂变：参与活动,通知代理人"),
    FISSION_TAKE_ACTIVITY(34, "裂变：参与活动"),
    FISSION_AGENT_COMPLETE_ACTIVITY(35, "裂变：有人完成,通知代理人"),
    FISSION_AGENT_MULTIPLE_MESSAGE(36, "裂变：代理人综合消息"),


    SINGLE_MESSAGE_USE(38, "一次性消息"),
    EARLY_WARNING_REMIND_TEMPLATE(39,"预警提醒"),

    CUSTOM_MESSAGE_SEND(40,"自定义内容推送模版降级"),
    AFTERNOON_CONTENT_PUSH(41,"12点内容推送"),


    GAME_TEMPLATE_LOTTERY(50, "抽奖工具：参与抽奖聚合推送"),
    GAME_TEMPLATE_LOTTERY_CUSTOM(51, "抽奖工具：中销售员指定奖品"),
    GAME_TEMPLATE_RECEIVED_CUSTOM(52, "抽奖工具：领取销售员指定奖品"),
    GAME_TEMPLATE_RECEIVED_CUSTOM_TEMPLATE(53, "抽奖工具：领取销售员指定奖品降级模板"),

    ;
    private Integer mark;
    private String desc;

    MessageMarkEnum(Integer mark, String desc) {
        this.mark = mark;
        this.desc = desc;
    }

    public Integer getMark() {
        return mark;
    }

    public String getDesc() {
        return desc;
    }

    public static MessageMarkEnum Of(Integer type) {
        for (MessageMarkEnum e :values())
            if (Objects.equals(type, e.getMark())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息");
    }

}
