package cn.com.duiba.kjy.api.remoteservice.accurate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.accurate.AccurateContentDetailDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.accurate.AccurateListParam;

import java.util.List;

/**
 * 精准素材文章库功能类
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemoteAccurateContentService {

    /**
     * 获取当前tag的文章数量
     * @param firstTagIds
     * @param companyId
     * @return
     */
    Long countByFirstTagId(List<Long> firstTagIds, Long companyId);

    /**
     *  筛选列表
     * @param accurateListParam
     * @return
     */
    Page<AccurateContentDetailDto> queryList(AccurateListParam accurateListParam);

    /**
     * 根据内容ids
     * @param contentIds
     * @return
     */
    List<AccurateContentDetailDto> listByContentIds(List<Long> contentIds);

    /**
     * 新增
     * @param accurateContentDetailDto
     * @return
     */
    Boolean save(AccurateContentDetailDto accurateContentDetailDto);

    /**
     * 根据内容id更新
     * @param accurateContentDetailDto
     * @return
     */
    Integer updateByContentId(AccurateContentDetailDto accurateContentDetailDto);

    /**
     * 根据内容id删除
     * @param contentId
     * @return
     */
    Boolean deleteByContentId(Long contentId);
}
