/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import org.apache.commons.lang3.StringUtils;

public class EmojiFilterUtils {
    private static boolean isEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static String filterEmoji(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return source;
        }
        StringBuilder buf = null;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!EmojiFilterUtils.isEmojiCharacter(codePoint)) continue;
            if (buf == null) {
                buf = new StringBuilder(source.length());
            }
            buf.append(codePoint);
        }
        if (buf == null) {
            return "";
        }
        if (buf.length() == len) {
            buf = null;
            return source;
        }
        return buf.toString();
    }
}

