package cn.com.duiba.kjy.api.constant;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum ContentStatusEnum {

    DRAFT(1, "草稿"),
    AVAILABLE(2, "正常"),
    INVALID(3, "过期,失效"),
    CRAWLER(4,"爬虫库"),
    ;

    private Integer code;
    private String desc;

    ContentStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ContentStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ContentStatusEnum typeEnum : ContentStatusEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
