package cn.com.duiba.kjy.api.params.greeting;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 节日贺卡访问记录查询参数
 * @author 刘超
 * @date 2019/12/18 17:31
 * @version 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GreetingCardRecordQueryParam extends PageQuery {

    private static final long serialVersionUID = -899497965612962712L;

    /**
     * 贺卡ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 活动配置ID，对应tb_seller_greeting_card_conf.id
     */
    private Long confId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 是否感谢：0-未答谢，1-答谢
     */
    private Integer thanks;
}
