package cn.com.duiba.kjy.api.remoteservice.greeting;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.greeting.GreetingCardRecordDto;
import cn.com.duiba.kjy.api.params.greeting.GreetingCardRecordQueryParam;

import java.util.List;

/**
 * 远程节日贺卡访问记录服务
 * @author 刘超
 * @date 2019/12/18 17:26
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteGreetingCardRecordService {

    /**
     * 根据配置id和访客用户id查询
     * @param confId 配置id
     * @param visitorId 访客用户id
     * @return 用户参与贺卡记录信息
     */
    GreetingCardRecordDto findByConfIdAndVisitorId(Long confId, Long visitorId);

    /**
     * 分页查询
     * @param queryParam 分页查询条件
     * @return 用户参与贺卡记录信息集合
     */
    List<GreetingCardRecordDto> findPageList(GreetingCardRecordQueryParam queryParam);

    /**
     * 保存访问记录
     * @param dto 用户参与贺卡记录信息
     * @return 是否成功
     */
    boolean save(GreetingCardRecordDto dto);

    /**
     * 答谢
     * @param confId 活动配置ID，对应tb_seller_greeting_card_conf.id
     * @param visitorId 用户ID(访问者)，对应 tb_users.id
     * @return 是否成功
     */
    boolean thanks(Long confId, Long visitorId);
}
