package cn.com.duiba.kjy.api.remoteservice.novice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.novice.SellerNoviceTaskDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-09-04 15:11
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerNoviceTaskService {

    /**
     * 查询任务列表
     * @param sellerId
     * @return
     */
    List<SellerNoviceTaskDto> listBySellerId(Long sellerId);

    /**
     * 统计已领取金额
     * @param sellerId
     * @return
     */
    Long countRewardedMoney(Long sellerId);

    /**
     * 完成任务领取奖励
     * @param sellerTaskId
     */
    boolean rewardMoney(Long sellerTaskId);

    /**
     * 根据主键查询
     * @param sellerTaskId
     * @return
     */
    SellerNoviceTaskDto getById(Long sellerTaskId);

    /**
     * 根据代理人id和任务id查询
     * @param sellerId
     * @param taskId
     * @return
     */
    SellerNoviceTaskDto getBySidAndTaskId(Long sellerId, Long taskId);

    /**
     * 代理人任务处理
     * @param sellerId
     * @param taskId
     * @return
     */
    Integer dealTask(Long sellerId, Long taskId);

    /**
     * 新增代理人任务
     * @param sellerNoviceTaskDto
     * @return
     */
    Integer add(SellerNoviceTaskDto sellerNoviceTaskDto);

    /**
     * 是否符合完善名片的标准
     * @param sid
     * @return
     */
    Boolean isFinishCardEdit(Long sid);

    /**
     * 根据主键查询列表
     * @param ids
     * @return
     */
    List<SellerNoviceTaskDto> listByIds(List<Long> ids);

    /**
     * 自动领取任务奖励
     * @param sellerId 代理人id
     * @return
     */
    Boolean autoRewardMoney(Long sellerId);

}
