package cn.com.duiba.kjy.api.enums.exclusive;

/**
 * 专区内容排序操作枚举
 * @author zhanghuifeng
 * date 2019-04-30-15:33
 */
public enum ExclusiveAreaItemSortOperateEnum {

    TO_UP(1, "上移"),
    TO_DOWN(2,"下移"),
    ;
    private Integer code;

    private String desc;

    ExclusiveAreaItemSortOperateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static ExclusiveAreaItemSortOperateEnum getByCode(Integer code) {
        for (ExclusiveAreaItemSortOperateEnum enumVal : ExclusiveAreaItemSortOperateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (ExclusiveAreaItemSortOperateEnum enumVal : ExclusiveAreaItemSortOperateEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
