package cn.com.duiba.kjy.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.activity.ActivityWinnerDto;

import java.util.List;

/**
 * @author lizhi
 * @date 2019/10/24 4:55 PM
 */
@AdvancedFeignClient
public interface RemoteActivityWinnerService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 中奖人信息
     */
    ActivityWinnerDto findById(Long id);

    /**
     * 保存中奖人
     * @param dto 参数
     * @return 主键
     */
    Long addWinner(ActivityWinnerDto dto);

    /**
     * 批量插入中奖人
     * @param dtos 中奖人信息
     * @return 中奖人信息（填充了主键）
     */
    List<ActivityWinnerDto> addWinners(List<ActivityWinnerDto> dtos);

    /**
     * 根据主键删除中奖人
     * @param id 主键
     * @return 执行结果
     */
    int removeWinner(Long id);

    /**
     * 更新活动配置ID
     * @param activityId 活动ID
     * @param activityConfId 活动配置ID
     * @param ids 要更新的主键
     * @return 执行结果
     */
    @Deprecated
    int updateActivityConfId(Long activityId, Long activityConfId, List<Long> ids);
}
