package cn.com.duiba.kjy.api.enums.fission;

import cn.com.duiba.kjy.api.enums.ContentSellerImportEnum;

/**
 * 奖品标签
 * @author：刘超
 * @Date 2019/12/13 14:27
 * @Version 1.0
 */
public enum FissionAwardLabelEnum {

    AUDIO("audio", "音频课程"),

    VIDEO("video", "视频课程"),

    BOOK("book","电子书"),

    MATERIAL("material", "电子资料"),

    RED_PACKET("red_packet", "红包"),

    GIFT("gift", "礼物"),

    ;

    private String code;
    private String desc;

    FissionAwardLabelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static FissionAwardLabelEnum getByCode(String code) {
        for (FissionAwardLabelEnum enumVal : FissionAwardLabelEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static FissionAwardLabelEnum getByDesc(String desc) {
        for (FissionAwardLabelEnum enumVal : FissionAwardLabelEnum.values()) {
            if (enumVal.getDesc().equals(desc)) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
