package cn.com.duiba.kjy.api.enums;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-29.
 * 消息配置的标记。一个功能一个标记。切勿重复哦
 */
public enum MessageMarkEnum {
    /**
     * 公众号、小程序消息配置
     */
    DAILY_TEMPLATE(1,"日报降级"),
    VISIT_TEMPLATE(2,"访问记录降级"),
    BUY_VIP_TEMPLATE(3,"会员购买成功"),
    SHARE_STATISTICS_TEMPLATE(4,"每日统计"),
    EVENING_GREETING_TEMPLATE(5,"晚安问候降级"),
    RETURN_MONEY(6,"收益发放通知"),
    WITHDRAW_MONEY(7,"提现成功通知"),

    VIP_INCOME_STATISTICS_TEMPLATE(8,"每日收益模板消息"),
    GUIDING_SUBSCRIBE_VIP(9,"引导关注VIP客服消息"),
    EVENING_GREETING_KEFU(10,"晚安问候客服消息"),
    USER_IN_CHAT_PAGE(11,"客户咨询客服消息通知，客户首次进入该会话聊天页"),
    USER_IN_CHAT_PAGE_TEMPLATE(12,"客户咨询模板消息通知，客户首次进入该会话聊天页"),
    USER_SEND_MESSAGE(13,"用户咨询客服消息通知，客户给代理人留言"),
    USER_SEND_MESSAGE_TEMPLATE(14,"用户咨询模板消息通知，客户给代理人留言"),
    USER_RECEIVE_MESSAGE(15,"客户接收代理人留言客服消息通知，客户消息小程序"),
    UPGRADE_GRADE_TEMPLATE(16,"等级升级通知"),
    ORDER_SEND_OUT(17,"订单发货通知"),

    AFTERNOON_ACTIVITY_KEFU(18,"下午动画推荐客服消息"),
    AFTERNOON_ACTIVITY_TEMPLATE(19,"下午动画推荐降级"),

    PRIVATE_CHAT_TEMPLATE(20,"代理人回复私聊，小程序模版消息"),

    SALES_PROMOTION_ONE_TEXT(21,"会销未付款用户22小时客服文字消息"),
    SALES_PROMOTION_TWO_TEXT(22,"会销未付款用户48小时客服文字消息"),
    SALES_PROMOTION_REMIND_PIC(23,"会销未付款用户48小时客服图文消息"),
    HOT_CONTENT_TEMPLATE(24, "热点内容模版消息"),
    COLLECT_CONTENT_INTERACTION(25, "收藏通知消息"),
    ACTIVITY_ACCURATE_CLUE(26, "活动精准线索推送"),

    ;
    private Integer mark;
    private String desc;

    MessageMarkEnum(Integer mark, String desc) {
        this.mark = mark;
        this.desc = desc;
    }

    public Integer getMark() {
        return mark;
    }

    public String getDesc() {
        return desc;
    }

    public static MessageMarkEnum Of(Integer type) {
        for (MessageMarkEnum e :values())
            if (Objects.equals(type, e.getMark())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的消息");
    }

}
