package cn.com.duiba.kjy.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.user.UsersWxInteractionDto;

/**
 * 用户与公众号交互信息
 * @author lizhi
 * @date 2019/12/3 6:09 PM
 */
@AdvancedFeignClient
public interface RemoteUsersWxInteractionService {

    /**
     * 新增或更新交互信息
     * @param dto 交互信息
     * @return 主键，为null说明失败了
     */
    Long saveOrUpdate(UsersWxInteractionDto dto);

    /**
     * 更新最后一次用户收到客服消息推送状态
     * @param openId
     * @param lastPushState
     * @see cn.com.duiba.kjy.api.enums.user.LastPushStateEnum
     * @return
     */
    Boolean updateLastPushState(String openId, Integer lastPushState);
}
