package cn.com.duiba.kjy.api.enums;

import cn.com.duiba.kjy.api.constant.UserExtTypeEnum;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-01.
 */
public enum OATypeEnum{
    CONTENT_MAIN_OA(1,"内容主体公众号"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.OA;
        }
    },
    VIP_OA(2,"付费用户的VIP专属公众号"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.VIP;
        }
    },
    MP(3,"客集集主体小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.MP;
        }
    },
    CLIENT_PUSH_MP(4,"客户接收私信消息的小程序"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.CLIENT_MP;
        }
    },

    FISSION_MP(5,"微信裂变小程序"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.FISSION_MP;
        }
    },

    GAME_MP(6,"抽奖模板小程序"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.GAME_MP;
        }
    },


    ;
    private Integer type;
    private String desc;

    OATypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e :values())
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

    public abstract UserExtTypeEnum change2ExtTypeEnum();
}
