package cn.com.duiba.kjy.api.dto.user;

import cn.com.duiba.kjy.api.enums.user.LastPushStateEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户与公众号交互信息
 * @author lizhi
 * @date 2019/12/03 4:43 PM
 */
@Data
public class UsersWxInteractionDto implements Serializable {

    private static final long serialVersionUID = -4837926230775629598L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 公众号ID，对应tb_official_accounts.id
     */
    private Long oaId;

    /**
     * 用户的标识，对当前公众号唯一
     */
    private String openId;

    /**
     * 最后一次交互消息类型：text、image、voice、video、shortvideo、location、link、event
     * @see cn.com.duiba.kjy.api.enums.user.WxMsgTypeEnum
     */
    private String lastMsgType;

    /**
     * 最后一次交互事件类型，仅在msg_type为event时有值：subscribe、unsubscribe、SCAN、LOCATION、CLICK、VIEW
     * @see cn.com.duiba.kjy.api.enums.user.WxEventTypeEnum
     */
    private String lastEventType;

    /**
     * 最后一次跟公众号交互的时间
     */
    private Date lastInteractionTime;

    /**
     * 最后一次客服消息推送状态
     * @see LastPushStateEnum
     */
    private Integer lastPushState;
}
