package cn.com.duiba.kjy.api.dto.push;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 推送管理的配置表
 * @author kjj mybatis generator
 * 2019-12-10
 */
@Data
public class PushManagerConfigDto implements Serializable {
    private static final long serialVersionUID = 15759653347278175L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *推送记录ID
     * not null default = null
     */
    private Long pushManagerId;

    /**
     *
     * 消息配置ID
     *   为空表示该条配置为客服消息的配置，各公众号公用，仅有一个
     *   不为空的为模版消息的配置，各公众号不同。一般为蓝号，红号各一个。如果，filterType = not_vip 那只需要配置蓝号的。 如果不要降级处理，那就没有
     */
    private Long messageConfigId;

    /**
     *
     *图片消息的微信返回的ID
     * max length = 50
     */
    private String picMediaId;

    /**
     *
     *模版消息跳转URL
     * max length = 255
     */
    private String templateUrl;

    /**
     *
     *客服文字消息的内容
     * max length = 800
     */
    private String customWords;

    /**
     *
     *模版消息内容的json
     * max length = 800
     */
    private String templateJson;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

}
