package cn.com.duiba.kjy.api.remoteservice.comment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.comment.MaterialCommentDto;

/**
 * @author 吴文哲
 * @date 2019-11-26 17:55
 **/
@AdvancedFeignClient
public interface RemoteMaterialCommentService {

    /**
     * 根据访客id scid 找到提交记录
     * @param visitorId
     * @param scid
     * @return
     */
    Integer getMaterialComment(Long visitorId,Long scid);

    /**
     * 根据id 根据主键查询
     * @param id
     * @return
     */
    MaterialCommentDto findById(Long id);

    /**
     * 保存评论记录 返回主键
     * @param dto
     * @return
     */
    Long saveComment(MaterialCommentDto dto);

    /**
     * 更新评论内容是否包含敏感信息
     * @param id
     * @param isSensitive
     * @return
     */
    Integer updateCommentSensitive(Long id,Boolean isSensitive);
}
