package cn.com.duiba.kjy.api.dto.sellercard;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Created by dugq on 2019-07-29.
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AuthenticationDto implements Serializable {
    private static final long serialVersionUID = -5241420278279513105L;

    /**
     * AuthTypeEnum
     */
    private Byte authType;

    /**
     * 是否开启
     */
    private Boolean open;

    /**
     * 代理人配置key
     */
    private String configKey;

    /**
     * 编号，不是每种证书都有
     * 4.0上线后废弃
     */
    @Deprecated
    private String authNo;

    /**
     * 认证名称(其它认证专用)
     * 4.0上线后废弃
     */
    @Deprecated
    private String authName;

    /**
     * 认证简称(其它认证专用)
     * 4.0上线后废弃
     */
    @Deprecated
    private String authSimpleName;

    public AuthenticationDto(Byte authType, Boolean open, String configKey) {
        this.authType = authType;
        this.open = open;
        this.configKey = configKey;
    }

    public AuthenticationDto(Byte authType, String authNo, String authName, String authSimpleName) {
        this.authType = authType;
        this.authNo = authNo;
        this.authName = authName;
        this.authSimpleName = authSimpleName;
    }
}
